/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.disc.fsp;

import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class FspUtil {
    private static final String TRACE_MASKD = "XFCSFUTD";
    private static final String TRACE_MASKF = "XFCSFUTF";
    private static final String TRACE_MASKT = "XFCSFUTT";
    private static final String LSHSC = "/opt/hsc/bin/lshsc";
    private static final String LSSYSCFG = "/opt/hsc/bin/lssyscfg";

    private FspUtil() {
    }

    public static String[] listAllManagedCecs() {
        Trace.trace(TRACE_MASKT, "-> listAllManagedCecs()");
        ArrayList<String> mtms = new ArrayList<String>();
        StringBuffer output = FspUtil.execPgm("/opt/hsc/bin/lshsc -i -t0");
        StringTokenizer st = new StringTokenizer(output.toString(), ";");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            try {
                String cec;
                int i = s.indexOf(":");
                if ((cec = s.substring(++i).trim()).equals("")) continue;
                Trace.trace(TRACE_MASKF, "Found CEC MTMS: " + cec);
                mtms.add(cec);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Error parsing token: " + s);
                Trace.trace(TRACE_MASKF, e);
            }
        }
        String[] mtmsArray = new String[mtms.size()];
        mtmsArray = mtms.toArray(mtmsArray);
        Trace.trace(TRACE_MASKT, "<- listAllManagedCecs()");
        return mtmsArray;
    }

    public static String[] listAllManagedCecs2() {
        Trace.trace(TRACE_MASKT, "-> listAllManagedCecs2()");
        ArrayList<String> mtms = new ArrayList<String>();
        StringBuffer output = FspUtil.execPgm("/opt/hsc/bin/lssyscfg -r sys -F \"type_model,serial_num\"");
        StringTokenizer st = new StringTokenizer(output.toString(), "\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            try {
                int i = s.indexOf(",");
                String cec = s.substring(0, i).trim() + "_" + s.substring(i + 1).trim();
                if (cec.equals("")) continue;
                Trace.trace(TRACE_MASKF, "Found CEC MTMS: " + cec);
                mtms.add(cec);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Error parsing token: " + s);
                Trace.trace(TRACE_MASKF, e);
            }
        }
        String[] mtmsArray = new String[mtms.size()];
        mtmsArray = mtms.toArray(mtmsArray);
        Trace.trace(TRACE_MASKT, "<- listAllManagedCecs2()");
        return mtmsArray;
    }

    public static InetAddress[] listHmcsManagingCec(String mtms) {
        Trace.trace(TRACE_MASKF, "-> listHmcsManagingCec(" + mtms + ")");
        if (mtms == null) {
            throw new IllegalArgumentException("MTMS may not be null");
        }
        ArrayList<InetAddress> hmcs = new ArrayList<InetAddress>();
        StringBuffer output = FspUtil.execPgm("/opt/hsc/bin/lshsc -i -r -c " + mtms);
        StringTokenizer st = new StringTokenizer(output.toString(), ";");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            try {
                if ((s = s.trim()).equals("")) continue;
                int i = s.indexOf(":");
                String ipString = s.substring(0, i).trim();
                Trace.trace(TRACE_MASKD, "Found IP string: " + ipString);
                try {
                    InetAddress iaddr = InetAddress.getByName(ipString);
                    hmcs.add(iaddr);
                    Trace.trace(TRACE_MASKF, "Resolved Address: " + ipString);
                }
                catch (UnknownHostException uhe) {
                    Trace.trace(TRACE_MASKF, "Unable to resolve host IP.  Ignorning");
                }
                catch (SecurityException se) {
                    Trace.trace(TRACE_MASKF, "Unable to resolve host IP due to security restrictions.  Ignorning.");
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Error parsing token: " + s);
                Trace.trace(TRACE_MASKF, e);
            }
        }
        InetAddress[] hmcsArray = new InetAddress[hmcs.size()];
        hmcsArray = hmcs.toArray(hmcsArray);
        Trace.trace(TRACE_MASKF, "<- listHmcsManagingCec(" + mtms + ")");
        return hmcsArray;
    }

    public static InetAddress[] listHmcsManagingCecs(String[] mtms) {
        Trace.trace(TRACE_MASKT, "-> listHmcsManagingCecs()");
        if (mtms == null) {
            throw new IllegalArgumentException("MTMS array may not be null");
        }
        ArrayList<InetAddress> iaddrs = new ArrayList<InetAddress>();
        for (int i = 0; i < mtms.length; ++i) {
            InetAddress[] ips = FspUtil.listHmcsManagingCec(mtms[i]);
            for (int j = 0; j < ips.length; ++j) {
                iaddrs.add(ips[j]);
            }
        }
        InetAddress[] iaddrsArray = new InetAddress[iaddrs.size()];
        iaddrsArray = iaddrs.toArray(iaddrsArray);
        Trace.trace(TRACE_MASKT, "<- listHmcsManagingCecs()");
        return iaddrsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static StringBuffer execPgm(String programName) {
        block12: {
            Trace.trace("XFCSFUTT", "-> execPgm(" + programName + ")");
            buffer = new StringBuffer();
            br = null;
            try {
                process = Runtime.getRuntime().exec(programName);
                br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                s = null;
                while ((s = br.readLine()) != null) {
                    Trace.trace("XFCSFUTD", "read: " + s);
                    buffer.append(s);
                    buffer.append("\n");
                }
                br.close();
                var6_6 = null;
                ** if (br == null) goto lbl-1000
            }
            catch (Throwable var5_12) {
                var6_8 = null;
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw var5_12;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block12;
                catch (IOException ioe) {
                    Trace.trace("XFCSFUTF", ioe);
                    var6_7 = null;
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        Trace.trace("XFCSFUTT", "<- execPgm(" + programName + "): " + buffer.toString());
        return buffer;
    }

    public static InetAddress[] findAllHmcs() {
        return FspUtil.listHmcsManagingCecs(FspUtil.listAllManagedCecs());
    }

    public static void main(String[] args) {
        String[] array1 = FspUtil.listAllManagedCecs();
        FspUtil.listHmcsManagingCecs(array1);
    }
}

